#!/bin/env python
#The script generates a symetric model of an ionic channel based on a single subunit. 
#The subunit must be positioned so that the channel axis equaled the z axis. 

#USAGE: c2s_generate_symetric <model> <sequence of chain_ids eg. ['A','C','B','D']>
import __main__
__main__.pymol_argv = [ 'pymol', '-qc'] #pymol arguments "c" - comand line, "q" - quiet output
import sys
import pymol
import math

pymol.finish_launching()

def calc_cog(model_name): #calculate center of geometry
        x,y,z=0,0,0
        for a in model_name.atom:
                x+=a.coord[0]
                y+=a.coord[1]
                z+=a.coord[2]
        x_o=x/len(model_name.atom)
        y_o=y/len(model_name.atom)
        z_o=z/len(model_name.atom)
        return x_o,y_o,z_o

struct1_file_name=sys.argv[1] #the sys.argv holds the input command line arguments
chain_names=sys.argv[2]
num_sub_u=len(chain_names)
trans_angl=(2*math.pi)/num_sub_u
pymol.cmd.load(struct1_file_name)#loading structures into PyMOL 
trans_mat=[math.cos(trans_angl),-math.sin(trans_angl),0,0,math.sin(trans_angl),math.cos(trans_angl),0,0,0,0,1,0,0,0,0,1]
struct_names=pymol.cmd.get_names()
chain_id=66
pymol.cmd.alter('%s' %(struct_names[0]),'chain=\'A\'')
#print "%c" %(chain_id)
for i in range(1,num_sub_u):
	pymol.cmd.create('str_%s'%(i),struct_names[i-1],0,0)
	pymol.cmd.alter('str_%s'%(i),'chain=\'%c\''%(chain_names[i]))
	struct_names=pymol.cmd.get_names()
	pymol.cmd.transform_selection(struct_names[i],trans_mat,0)
	chain_id=chain_id+1

symetric_model_file_name="%s_SYM.pdb" %(struct_names[0])
print "Writing symetric model to: %s " % (symetric_model_file_name)
pymol.cmd.save(symetric_model_file_name,"all",0)

pymol.cmd.quit()

