#!/bin/env python
#The scripts measures the distances between aminoacids that form the core of 
#the selectivity filter within the KcsA structure (res 75-82)
#USAGE: c2s_measure_dist.py <model_file>


import __main__
__main__.pymol_argv = [ 'pymol', '-qc'] #pymol arguments "c" - comand line, "q" - quiet output
import sys
import pymol

def r2r_min_dist(struct_name,sel_res1, sel_res2):

	single_raw=[]
	pymol.dist_tab=[]
	pymol.atom_id1=[]
	pymol.atom_id2=[]
	pymol.cmd.iterate('%s' % (sel_res1),'atom_id1.append(index)')
	pymol.cmd.iterate('%s' % (sel_res2),'atom_id2.append(index)')
	for i in range(len(pymol.atom_id1)):
		single_raw=[]
		for j in range(len(pymol.atom_id2)):
			temp_obj="temp_obj"
			single_raw.append(pymol.cmd.distance('%s' % (temp_obj),'index %s' % (pymol.atom_id1[i]),'index %s' %( pymol.atom_id2[j])))
			pymol.cmd.delete(temp_obj)
		pymol.dist_tab.append(single_raw)
		
	min_dist=min(min(pymol.dist_tab))
	return min_dist

pymol.finish_launching()
struct1=sys.argv[1] #the sys.argv holds the input command line arguments
offset=int(sys.argv[2])
pymol.cmd.load(struct1)#loading structures into PyMOL 
pymol.offset=offset
struct_names=pymol.cmd.get_names()
pymol.cmd.alter('%s' % ( struct_names[0]),'resi= str(int(resi)+offset)')
file_pore=open('%s_pore_width.txt' % (struct_names[0]),'w')
file_pore.write('Model_name\t')

dist_list=[]
pymol.res_name=[]
for i in range(75,81):
	pymol.cmd.select('sel_res1','c. A & i. %d' %(i))
	pymol.cmd.select('sel_res2','c. D & i. %d' %(i))
	pymol.cmd.select('sel_res3','c. C & i. %d' %(i))
	pymol.cmd.select('sel_res4','c. B & i. %d' %(i))
	dist_list.append(r2r_min_dist(struct_names[0],'sel_res1','sel_res2'))
	dist_list.append(r2r_min_dist(struct_names[0],'sel_res3','sel_res4'))
	pymol.cmd.iterate('sel_res1 & n. CA','res_name.append([resn,resi])')
if (len(sys.argv)==4):
	struct2=sys.argv[3]
	pymol.cmd.load(struct2,'target_struct')
	struct_names=pymol.cmd.get_names()
	pymol.cmd.align('%s' % (struct_names[0]),'%s' % (struct_names[1]))
	axis_dist=[] #distance of Oxygens from ions in the selectivity filter
	axis_dist_raw=[]
	pos_displ=[] #displacement from corect position
	pos_displ_raw=[]
	chains=['A','B','C','D']
	for j in chains:
		temp_obj='temp_obj'
		axis_dist_raw.append(pymol.cmd.dist('%s'%(temp_obj),'%s & i. %d & c. %s & name OG1'  % (struct_names[0],75,j),'%s & index %d' % (struct_names[1],2503)))
		pos_displ_raw.append(pymol.cmd.dist('%s'%(temp_obj),'%s & i. %d & c. %s & name OG1'  % (struct_names[0],75,j),'%s & i. %d & c. %s & name OG1 ' % (struct_names[1],75,j)))
		pymol.cmd.delete(temp_obj)
	axis_dist.append(axis_dist_raw)
	pos_displ.append(pos_displ_raw)
	for i in range(75,80):
		axis_dist_raw=[]
		pos_displ_raw=[]
		rb_index={
		75: 2503,
        	76: 2502,
        	77: 2504,
        	78: 2504,
        	79: 2504
		}
		for j in chains:
			tem_obj='temp_obj'
			axis_dist_raw.append(pymol.cmd.dist('temp_obj','%s & i. %d & c. %s & n. O'  % (struct_names[0],i,j),'%s & index %d' % (struct_names[1],rb_index[i])))
			pos_displ_raw.append(pymol.cmd.dist('temp_obj','%s &i. %d & c. %s & n. O'  % (struct_names[0],i,j),'%s &i. %d & c. %s & n. O'  % (struct_names[1],i,j)))
			pymol.cmd.delete('temp_obj')
		axis_dist.append(axis_dist_raw)
		pos_displ.append(pos_displ_raw)
	file_dist=open('%s_at_dist.txt' %(struct_names[0]), 'w')
	file_dist.write('Model_name\t')
	for i in chains:
		file_dist.write('THR|75|%s|OG|ax\tTHR|75|%s|OG|pos\t'%(i,i))
	for i in range(6):
		for j in chains:
			file_dist.write('%s|%s|%s|a\t %s|%s|%s|p\t'%(pymol.res_name[i][0],pymol.res_name[i][1],j,pymol.res_name[i][0],pymol.res_name[i][1],j))
	file_dist.write('\n%s\t'%(struct_names[0]))
	for i in range(len(axis_dist)):
		for j in range(len(chains)):
			file_dist.write('%2.3f\t%2.3f\t'%(axis_dist[i][j],pos_displ[i][j]))
	file_dist.write('\n')
	file_dist.close()
for i in range(len(pymol.res_name)):
	file_pore.write('%s|%s|AD\t%s|%s|BC\t' % (pymol.res_name[i][0],pymol.res_name[i][1],pymol.res_name[i][0],pymol.res_name[i][1]))
file_pore.write('\n%s\t' % (struct_names[0]))
for i in dist_list:
	file_pore.write('%2.3f\t'% (i) )
file_pore.write('\n')
file_pore.close()
