#!/bin/env python
#The script calculates rmsd between two structures with pyMOL align function without opening pyMOL
#USAGE: c2s_rmsd_analysis <model> <target> <focus_residue_1> <focus_residue_2> <offset>
import __main__
__main__.pymol_argv = [ 'pymol', '-qc'] #pymol arguments "c" - comand line, "q" - quiet output
import sys
import pymol

pymol.finish_launching()

#pymol.cmd.feedback("disable","all","actions")
#pymol.cmd.feedback("disable","all","results")


selection='(n. ca | n. cb)' #c-alpha or c-beta atoms are chosen for rmsd calculations
struct1=sys.argv[1] #the sys.argv holds the input command line arguments
struct2=sys.argv[2]
focus_res_1=int(sys.argv[3])
focus_res_2=int(sys.argv[4])
offset=int(sys.argv[5])
small_1=75
small_2=84
pymol.offset=offset

pymol.cmd.load(struct1)#loading structures into PyMOL 
pymol.cmd.load(struct2)
struct_names=pymol.cmd.get_names()
#pymol.cmd.alter('struct_names[0]','resi=resi+offset')
pymol.cmd.alter('%s' % ( struct_names[0]),'resi= str(int(resi)+offset)')
rms  = pymol.cmd.align('%s and %s' % (struct_names[0],selection),'%s and %s' % (struct_names[1],selection)) #aligning structures 
pymol.cmd.select('m_select_1','%s & i. %d-%d' % (struct_names[0],focus_res_1, focus_res_2)) #making proper selections
pymol.cmd.select('t_select_1','%s & i. %d-%d' % (struct_names[1],focus_res_1, focus_res_2))
pymol.cmd.select('m_select_2','%s & i. %d-%d' % (struct_names[0],small_1, small_2))
pymol.cmd.select('t_select_2','%s & i. %d-%d' % (struct_names[1],small_1, small_2))
pymol.cmd.select('m_select_1_ca', 'm_select_1 & n. ca')
pymol.cmd.select('m_select_2_ca', 'm_select_2 & n. ca')
pymol.res_list=[]
pymol.res_filt_centr_list=[]

pymol.cmd.iterate('m_select_1_ca','res_list.append([resi,chain,resn])')
pymol.cmd.iterate('m_select_2_ca','res_filt_centr_list.append([resi,chain,resn])')

res_rms_list=[]
for i in range(len(pymol.res_list)):
	pymol.cmd.select('tmp_m_select','m_select_1 & resi %s & chain %s' % (pymol.res_list[i][0],pymol.res_list[i][1]))
	pymol.cmd.select('tmp_t_select','t_select_1 & resi %s & chain %s' % (pymol.res_list[i][0],pymol.res_list[i][1]))
	res_rms_list.append(pymol.cmd.rms_cur('tmp_m_select','tmp_t_select'))

rms_whole_filter = pymol.cmd.rms_cur('m_select_1','t_select_1')
rms_filter_centr=pymol.cmd.rms_cur('m_select_2','t_select_2')

#Fiting of the whole filter part
rms_whole_filter_fit = pymol.cmd.align('m_select_1','t_select_1') #new alignment
res_filt_rms_list=[]
for i in range(len(pymol.res_list)):
	pymol.cmd.select('tmp_m_select','m_select_1 & resi %s & chain %s' % (pymol.res_list[i][0],pymol.res_list[i][1]))
	pymol.cmd.select('tmp_t_select','t_select_1 & resi %s & chain %s' % (pymol.res_list[i][0],pymol.res_list[i][1]))
	res_filt_rms_list.append(pymol.cmd.rms_cur('tmp_m_select','tmp_t_select'))


#Fiting of resiudes in the center of the selectivity filter
rms_filter_centr_fit = pymol.cmd.align('m_select_2','t_select_2') #new alignment
res_filt_centr_rms_list=[]
for i in range(len(pymol.res_filt_centr_list)):#selecting each pair of residues and calculating the rmsd of all heavy atoms
	pymol.cmd.select('tmp_m_select','m_select_2 & resi %s & chain %s' % (pymol.res_filt_centr_list[i][0],pymol.res_filt_centr_list[i][1]))
	pymol.cmd.select('tmp_t_select','t_select_2 & resi %s & chain %s' % (pymol.res_filt_centr_list[i][0],pymol.res_filt_centr_list[i][1]))
	res_filt_centr_rms_list.append(pymol.cmd.rms_cur('tmp_m_select','tmp_t_select'))


pymol.cmd.quit()


#Printing general RMSDs to output file *_rmsd_analysis.txt
file_rmsd=open('%s_rmsd_analysis.txt' % (struct_names[0]), 'w')
file_rmsd.write('Model_name\tFull alignment\tResidues %d-%d\tFitted on %d-%d\tResidues %d-%d\tFitted on %d-%d' % (focus_res_1,focus_res_2,focus_res_1,focus_res_2, small_1, small_2,small_1,small_2)) 
file_rmsd.write('\n%s\t%2.3f\t%2.3f\t%2.3f\t%2.3f\t%2.3f\n' % (struct_names[0],rms[3],rms_whole_filter,rms_whole_filter_fit[3], rms_filter_centr, rms_filter_centr_fit[3]))
file_rmsd.close()

#Printing residue rmsds based on general ca and cb alignment to output file *_residues_rmsd.txt
file_res=open('%s_residues_rmsd.txt' % (struct_names[0]), 'w')
file_res.write('Model_name\t')
for i in range(len(pymol.res_list)):
	file_res.write('%s|%s|%s\t' % (pymol.res_list[i][2],pymol.res_list[i][0],pymol.res_list[i][1]))
file_res.write('\n%s\t'% (struct_names[0]))
for i in res_rms_list:
	file_res.write('%f\t' % (i))
file_res.write('\n')
file_res.close()

#Printing residue rmsds based on filter alignment to output file *_residues_filt_rmsd.txt
file_res_filt=open('%s_res_filt_rmsd.txt' % (struct_names[0]), 'w')
file_res_filt.write('Model_name\t')
for i in range(len(pymol.res_list)):
	file_res_filt.write('%s|%s|%s\t' % (pymol.res_list[i][2],pymol.res_list[i][0],pymol.res_list[i][1]))
file_res_filt.write('\n%s\t'% (struct_names[0]))
for i in res_filt_rms_list:
	file_res_filt.write('%f\t' % (i))
file_res_filt.write('\n')
file_res_filt.close()

#Printing residue rmsds based on filter center alignment to output file *_residues_filt_centr_rmsd.txt
file_res_filt_centr=open('%s_res_filt_centr_rmsd.txt' % (struct_names[0]), 'w')
file_res_filt_centr.write('Model_name\t')
for i in range(len(pymol.res_filt_centr_list)):
	file_res_filt_centr.write('%s|%s|%s\t' % (pymol.res_filt_centr_list[i][2],pymol.res_filt_centr_list[i][0],pymol.res_filt_centr_list[i][1]))
file_res_filt_centr.write('\n%s\t'% (struct_names[0]))
for i in res_filt_centr_rms_list:
	file_res_filt_centr.write('%f\t' % (i))
file_res_filt_centr.write('\n')
file_res_filt_centr.close()



#for i in alignmentprint rms[3]


