#!/bin/env python
#The script calculates the cylindrical coordinates of atoms in the ionich channel

#USAGE: c2s_axis_analysis <model> <focus_residue_1> <focus_residue_2> <offset>
import __main__
__main__.pymol_argv = [ 'pymol', '-qc'] #pymol arguments "c" - comand line, "q" - quiet output
import sys
import pymol
import math
pymol.finish_launching()

def sgn(num):
	if(num < 0): return -1;
	elif(num > 0): return 1;
	else: return 0;

def calc_cog(model_name): #calculate the center of geometry of a model
        x,y,z=0,0,0
        for a in model_name.atom:
                x+=a.coord[0]
                y+=a.coord[1]
                z+=a.coord[2]
        x_o=x/len(model_name.atom)
        y_o=y/len(model_name.atom)
        z_o=z/len(model_name.atom)
        return x_o,y_o,z_o

def calc_atom_xy_angle(chempy_atom): #the function calcualtes the angle needed to rotate the chempy_atom onto x axis  
	x=chempy_atom.coord[0]
	y=chempy_atom.coord[1]
	r=math.sqrt(math.pow(x,2)+math.pow(y,2))
	c_2=math.pow(y,2)+math.pow((r-x),2)
	rot_angl=math.acos((2*math.pow(r,2)-c_2)/(2*math.pow(r,2))) #The Cosine Theorem (Carnot's) is used 
	return sgn(y)*rot_angl

struct_file_name=sys.argv[1] #the sys.argv holds the input command line arguments
#focus_res_1=int(sys.argv[2])
#focus_res_2=int(sys.argv[3])
#offset=int(sys.argv[4])
#pymol.offset=offset


pymol.cmd.load(struct_file_name)#loading structures into PyMOL 
struct_names=pymol.cmd.get_names()
pymol.cmd.remove('element H') # removing all H atoms


#Positioning the structure

#The axis of the chanel should be located in the center of the origin 
chempy_model=pymol.cmd.get_model(struct_names[0])
cog=calc_cog(chempy_model) 
pymol.cmd.translate([-cog[0],-cog[1],0],struct_names[0]) # translation to the center of origin (x,y plane only)

#All angles in the axis analysis are calculated in the reference to the position of CA chain A location
pymol.N_term_list=[]
pymol.cmd.iterate('%s & c. A'%struct_names[0],'N_term_list.append(int(resi))')
fst_resi=min(pymol.N_term_list)
print fst_resi
pymol.cmd.select('chain_Aca','c. A & i. %d & n. ca' %(fst_resi))
CA_chempy_model=pymol.cmd.get_model('chain_Aca') 
rot_angl=calc_atom_xy_angle(CA_chempy_model.atom[0]) 
trans_mat=[math.cos(-rot_angl),-math.sin(-rot_angl),0,0,math.sin(-rot_angl),math.cos(-rot_angl),0,0,0,0,1,0,0,0,0,1]

pymol.cmd.transform_selection(struct_names[0],trans_mat,0) #rotation of the structure (CA of res1 rotated onto x axis)
print "Positioning the structure"
print "Rotation angle: %f" % (rot_angl)
print "Translation vector:  %f  %f  %f" % (cog[0],cog[1],cog[2])
#print "Translation_matrix: " 
#for i in trans_mat: print "\t%f" %(i);

#Calculating axis related parameters

pymol.cmd.select('chainA', 'c. A') #The calculations are conducted only for chain A atoms (symetry)
chainA_chempy_model=pymol.cmd.get_model('chainA')
i=0
angles=[]
r_axis=[]
height=[]

for a in chainA_chempy_model.atom:
	r=math.sqrt(pow(a.coord[0],2)+pow(a.coord[1],2))
	angle=calc_atom_xy_angle(a)#The function uses the cosine theorem "Carnot's Theorem"
	if angle<0:angle=2*math.pi+angle;
	angles.append(angle)
	r_axis.append(r)
	height.append(a.coord[2])
	#print "%s|%s\t|%s %3.3f %3.3f " %(a.resn, a.resi, a.name,r,angle) 
#Printing angles, axis_dist, heighth, relative_heights to file *_axis_analysis.txt
#pymol.cmd.save('control.pdb','all',0)
file_axis=open('%s_axis_analysis.txt' % (struct_names[0]), 'w')
file_axis.write('Model_name\t')
for a in chainA_chempy_model.atom:
        file_axis.write('%s|%s|%s|angle|\tr_axis|\theight|\th_rel|\t' % (a.resn,a.resi,a.name))
file_axis.write('\n%s\t'% (struct_names[0]))
for i in range(0,len(angles)):
        file_axis.write('%f\t%f\t%f\t%f\t' % (math.degrees(angles[i]),r_axis[i],height[i],height[i]))
file_axis.write('\n')
file_axis.close()



pymol.cmd.quit()

