#!/bin/env python
#The script generates a symetric model of an ionic channel based on a single subunit. 
#The subunit must be positioned so that the channel axis equaled the z axis. 

#USAGE: c2s_generate_average <model1> <model2> <model3>....
import __main__
__main__.pymol_argv = [ 'pymol', '-qc'] #pymol arguments "c" - comand line, "q" - quiet output
import sys
import pymol #pymol library
import math
import re #regular expresions


pymol.finish_launching()
struct_file_names=[]
averaged_struct="Averaged_struct"
struct_num=len(sys.argv)-1
print "Averageing %d structrues"%(struct_num)

for i in range(1,len(sys.argv)):
	struct_file_names.append(sys.argv[i])
	pymol.cmd.load(sys.argv[i])
struct_names=pymol.cmd.get_names()
for i in struct_names:
	pymol.cmd.select("s_%s"%(i),"%s & (n. ca)"%(i))
for i in range(1,struct_num):
	pymol.cmd.align("s_%s"%(struct_names[i]),"s_%s"%(struct_names[0]),cycles=0)
	print "Aligning %s on %s" % (struct_names[i], struct_names[0])
chempy_models=[]
for i in range(1,struct_num):
	pymol.cmd.create('%s_al'%(struct_names[i]), "s_%s"%(struct_names[i]))
	chempy_models.append(pymol.cmd.get_model('%s_al'%(struct_names[i])))
pymol.cmd.create(averaged_struct,"s_%s" % (struct_names[0]))
averaged_chempy=pymol.cmd.get_model("%s" % (averaged_struct)) #change

for a in range(0,len(averaged_chempy.atom)):
#	print "s0 %s  %s  %s" % (averaged_chempy.atom[a].coord[0],averaged_chempy.atom[a].coord[1],averaged_chempy.atom[a].coord[2])
	for i in range(0,len(chempy_models)):
#		print "%d: %s  %s  %s" % (i,chempy_models[i].atom[a].coord[0],chempy_models[i].atom[a].coord[1],chempy_models[i].atom[a].coord[2])
		averaged_chempy.atom[a].coord[0]+=chempy_models[i].atom[a].coord[0]
		averaged_chempy.atom[a].coord[1]+=chempy_models[i].atom[a].coord[1]
		averaged_chempy.atom[a].coord[2]+=chempy_models[i].atom[a].coord[2]
#	print "sum %s  %s  %s" % (averaged_chempy.atom[a].coord[0],averaged_chempy.atom[a].coord[1],averaged_chempy.atom[a].coord[2])
	averaged_chempy.atom[a].coord[0]=averaged_chempy.atom[a].coord[0]/struct_num
	averaged_chempy.atom[a].coord[1]=averaged_chempy.atom[a].coord[1]/struct_num
	averaged_chempy.atom[a].coord[2]=averaged_chempy.atom[a].coord[2]/struct_num
#	print "dev %s  %s  %s" % (averaged_chempy.atom[a].coord[0],averaged_chempy.atom[a].coord[1],averaged_chempy.atom[a].coord[2])
#for a in averaged_chempy.atom:
#	print "%s  %s  %s" % (a.coord[0],a.coord[1],a.coord[2])
av_file_name_prep=re.match('(.*)(_[A-Z])(.pdb)',struct_file_names[0])
averaged_file_name='%s_AV.pdb' % (av_file_name_prep.group(1))
print "Writing averaged structure to: %s" %(averaged_file_name)
pymol.cmd.load_model(averaged_chempy,'%s_1'% (averaged_struct))
pymol.cmd.save(averaged_file_name,'%s_1'%(averaged_struct),'0')
