#! /usr/bin/env python
#The python script needs pymol to work. It aligns a model structure onto a template structure and changes its coordinates.
#The purpose is to orient the model structure of a channel perpendicular to the plane of the cell membrane so it could be input for further processing.
#USAGE:

	#python <c2s_orient_struct.py> <model_structure> <template-structure> 

import __main__
__main__.pymol_argv = [ 'pymol', '-qc'] #pymol arguments "c" - comand line, "q" - quiet output
import sys
import pymol

pymol.finish_launching()

print "Running PyMOL for orientating the structure"


model_file_name=sys.argv[1] #the sys.argv holds the input command line arguments
template_file_name=sys.argv[2]

object2=pymol.cmd.load(template_file_name) #loading structures into PyMOL 
object1=pymol.cmd.load(model_file_name)
struct_names=pymol.cmd.get_names()
print struct_names[0]
print struct_names[1]
rms  = pymol.cmd.align(struct_names[1],struct_names[0])
print rms
pymol.cmd.save(model_file_name,struct_names[1],0)
pymol.cmd.quit()

