#!/bin/env python
#The script positions the model structure. It calculates the center of geometry in the xy plane and moves it to center of origin.
#USAGE: c2s_model_positioning.py <structure_file_name>




import __main__
__main__.pymol_argv = [ 'pymol', '-qc'] #pymol arguments "c" - comand line, "q" - quiet output
import sys
import pymol
import math
pymol.finish_launching()


def calc_cog(model_name): #calculate the center of geometry of a model (chempy_model_type)
        x,y,z=0,0,0
        for a in model_name.atom:
                x+=a.coord[0]
                y+=a.coord[1]
                z+=a.coord[2]
        x_o=x/len(model_name.atom)
        y_o=y/len(model_name.atom)
        z_o=z/len(model_name.atom)
        return x_o,y_o,z_o

structure_file_name=sys.argv[1]
pymol.cmd.load(structure_file_name)
struct_names=pymol.cmd.get_names()
print "Positioning: %s" % (struct_names[0])
chempy_model=pymol.cmd.get_model("%s & n. ca" % (struct_names[0]),0)
cog=calc_cog(chempy_model)
pymol.cmd.translate([-cog[0],-cog[1],0],struct_names[0]) # translation to the center of origin (x,y plane only)
pymol.cmd.save(structure_file_name,struct_names[0],0)

