#!/bin/bash
#The script setups everything for running the pipeline from contact map based reconstruction till orientated pdb structure.
#The script will unpack FT-COMAR, create a symbolic link to SCWRL 4.0 run file, and add the src directory to the $PATH environmental viarable.
#It also adds a line to .bash_profile file to make the modification of PATH constant. The script also changes two paths in 
#cmap_insert_loop and pdb_cat_chains scripts. This scripts use awk and proper paths need to be set.  

#After running the init_pipe.sh script you can use cmap2struct to run the pipline. Run the script without arguments to see what arguments are needed.


tar -xzvf FT-COMAR.tgz
ln -s SCWRL/Scwrl4 ./scwrl4
mv ./FT-COMAR ./ftcomar
src_directory=`pwd`

sed -i -e 's|File.*$|FilePath = '$PWD'\/SCWRL\/bbDepRotLib.bin|p' SCWRL/Scwrl4.ini 
sed -i -e 's|AWK_SCRIPT_PATH=.*\#|AWK_SCRIPT_PATH='${src_directory}'\/cmap_insert_loop.awk\ \#|' cmap_insert_loops
sed -i -e 's|pdb_cat_chains_awk=.*\#|pdb_cat_chains_awk='${src_directory}'\/pdb_cat_chains.awk\ \#|' pdb_cat_chains
sed -i -e 's|.*<pdb_file>.*|'${src_directory}'\/Example\/3fb7_assembly.pdb	\#<pdb_file> original pdb file|' cmap2struct_args.in
sed -i -e 's|.*<orient_pdb_full_path>.*|'${src_directory}'\/Example\/3fb7_banhC.pdb	\#<orient_pdb_full_path> - pdb_file for orienting models perpendicular to membrane|' cmap2struct_args.in

if [ -e ~/.bash_profile ]; then
	echo "PATH=\$PATH:${src_directory}" >> ~/.bash_profile
	export PATH=$PATH:${src_directory}
else 
	echo "~/.bash_profile does not exist!"
fi

echo "Running Example"
echo "Generating model with c2s_generate_models"
cd ./Example/3fb7_1con12
cp -r ../../cmap2struct_args.in .
c2s_generate_models cmap2struct_args.in 1 0 2>err.example
#cmap2struct 3fb7_assembly_1con12.cmap 12 0 ../3fb7_assembly.pdb 8 1 1 20 89 178 267
echo "**********************************************************************"
echo "If everything went well the results should be located in `pwd`/0/Final_chains"
echo "**********************************************************************"
echo "Check ${src_directory}/Example/3fb7_1con12/err.example for errors"
echo "Printing err.example:"
cat err.example
echo "**********************************************************************"
echo "Reboot now, the directory with scripts should be added to the PATHS variable"
